/********************************** (C) COPYRIGHT *******************************
* File Name          : USB_HOST.H
* Author             : MJX
* Version            : V1.00
* Date               : 2020/05/15
* Description        : USBͨòͷļ
*******************************************************************************/



#ifndef __USB_HOST_H__
#define __USB_HOST_H__

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************/
/* ͷļ */
#include "MAIN.H"	 															/* ͷļ */

/********************************************************************************/
/* غ궨 */
#define	pSetupReq			       ((PXUSB_SETUP_REQ)TxBuffer )

#define	WAIT_USB_TOUT_200US		   1000  										/* ȴUSBжϳʱʱ200uS@Fsys=24MHz */

/* ӳ򷵻״̬ */
#ifndef	ERR_SUCCESS
#define	ERR_SUCCESS				   0x00											/* ɹ */
#define	ERR_USB_CONNECT			   0x15											/* ⵽USB豸¼,Ѿ */
#define	ERR_USB_DISCON			   0x16											/* ⵽USB豸Ͽ¼,ѾϿ */
#define	ERR_USB_BUF_OVER		   0x17											/* USB̫໺ */
#define	ERR_USB_DISK_ERR		   0x1F											/* USB洢ʧ,ڳʼʱUSB洢֧,ڶдпǴ𻵻ѾϿ */
#define	ERR_USB_TRANSFER		   0x20											/* NAK/STALLȸ0x20~0x2F */
#define	ERR_USB_UNSUPPORT		   0xFB
#define	ERR_USB_UNKNOWN			   0xFE
#endif

#ifndef	BUS_RESET_TIME
#define	BUS_RESET_TIME			   11											/* USB߸λʱ10mS20mS */
#endif

#define DEC_DESCR_GETFAIL          0x45 
#define DEV_TYPE_UNKNOW 	   	   0xFF	  										/* USB豸δ֪ */

/* USB豸Ϣ,CH545֧4豸 */
#define	ROOT_DEV_DISCONNECT		   0
#define	ROOT_DEV_CONNECTED		   1
#define	ROOT_DEV_FAILED			   2
#define	ROOT_DEV_SUCCESS		   3

typedef struct _ROOT_HUB_DEVICE
{
	UINT8  bStatus;																/* ǰ豸״̬,0-豸,1-豸δʼ,2-豸ʼöʧ,3-豸ҳʼöٳɹ */
	UINT8  bType;																/* ǰ豸 */
	UINT8  bAddress;															/* ǰ豸USBַ */
	UINT8  bSpeed;																/* ǰ豸ٶ: 0Ϊ,0Ϊȫ */
	UINT8  bEp0MaxPks;															/* ǰ豸˵0С */
	UINT8  DeviceIndex;														    /* ΪUSBX֮HUB豸,11ӦΪֱͨ豸 */
	UINT8  bPortNum;															/* ǰ豸˿Ŀ */
	UINT16 bChkTimeCount;													   	/* ǰ豸˿ڲѯʱ */
}ROOT_HUB_DEVICE, *PROOT_HUB_DEVICE;

/******************************************************************************/
/*  */
extern UINT8C SetupGetDevDescr[ ];   											/* ȡ豸 */
extern UINT8C SetupGetCfgDescr[ ];											/* ȡ */
extern UINT8C SetupGetStrDescr[ ];	 										/* ȡַ */
extern UINT8C SetupSetUsbAddr[ ];		  										/* USBַ */
extern UINT8C SetupSetUsbConfig[ ];	   										/* USB */
extern UINT8C SetupClrEndpStall[ ];											/* ˵STALL */
extern UINT8C SetupGetHubDescr[ ];											/* ȡHUB */

extern UINT8X UsbDevEndp0Size;												/* USB豸Ķ˵0ߴ */
extern UINT8X RxBuffer[ MAX_PACKET_SIZE ] ;  									/* IN, must even address */
extern UINT8X TxBuffer[ MAX_PACKET_SIZE ] ;  									/* OUT, must even address */
extern UINT8  RootHubId;														/* ǰڲroot-hub˿ں:0=HUB0,1=HUB1,2=HUB2,3=HUB3 */

extern struct _ROOT_HUB_DEVICE xdata RootHubDev[ 4 ];							/* HUB豸ؽṹ嶨 */

/********************************************************************************/
/*  */
extern void USBH_DisableRootHubPort( UINT8 index );								/* USBرָROOT-HUB˿ */
extern UINT8 USBH_Check_RootHubStatus( UINT8 index );							/* USBָROOT-HUB˿Ƿʹ */
extern void USBH_SetSelfAddr( UINT8 addr );										/* USBõǰҪUSB豸ַ */
extern void USBH_SetSelfSpeed( UINT8 speed );									/* USBUSBٶ */	
extern void USBH_ResetRootHubPort( UINT8 index, UINT8 mod );					/* USBλӦ˿ڵ */
extern UINT8 USBH_EnableRootHubPort( UINT8 index );								/* USBʹROOT-HUB˿ */
extern void USBH_SelectHubPort( UINT8 index );									/* USBѡָROOT-HUB˿ */
extern UINT8 USBH_Transact( UINT8 endp_pid, UINT8 tog, UINT16 timeout );   		/* USBִд */
extern UINT8 USBH_CtrlTransfer( PUINT8X DataBuf, PUINT16 RetLen );	 			/* USBִпƴ */
extern void USBH_CopySetupReqPkg( PUINT8C pReqPkt );							/* USBƿƴ */
extern UINT8 USBH_GetDeviceDescr( UINT8 *pbuf );								/* USBȡ豸 */
extern UINT8 USBH_GetConfigDescr( UINT8 *pbuf, UINT16 *plen );					/* USBȡ */
extern UINT8 USBH_GetStrDescr( UINT8 num, UINT8 *pbuf );						/* USBȡַ */
extern UINT8 USBH_SetUsbAddress( UINT8 addr );									/* USBUSB豸ַ */
extern UINT8 USBH_SetUsbConfig( UINT8 cfg );									/* USBUSB豸 */
extern UINT8 USBH_ClearEndpStall( UINT8 endp );									/* USB˵STALL */
extern void USBH_Init( void );													/* USBʼ */			

#ifdef __cplusplus
}
#endif

#endif

/*********************************END OF FILE**********************************/
